package ru.yandex.chemodan.log;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.CamelWords;
import ru.yandex.misc.monica.annotation.MonicaContainer;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.annotation.MonicaStaticRegistry;
import ru.yandex.misc.monica.core.blocks.MeterMap;
import ru.yandex.misc.monica.core.blocks.UpdateMode;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author tolmalev
 */
public class MonicaMeasureExceptionsAppender extends AbstractAppender implements MonicaContainer {

    @MonicaMetric
    private final MeterMap exceptions = new MeterMap();
    @MonicaMetric
    private final MeterMap exceptionsBySource = new MeterMap();

    @MonicaMetric
    private final MeterMap linesByLevel = new MeterMap();

    public MonicaMeasureExceptionsAppender() {
        super("MonicaMeasureExceptions", null, null);
        MonicaStaticRegistry.register(this, CamelWords.parse(getClass().getSimpleName()).toJavaIdentifier());
    }

    @Override
    public void append(LogEvent event) {
        String logLevel = event.getLevel().toString().toLowerCase();
        linesByLevel.inc(logLevel);

        Throwable thrown = event.getThrown();
        if (thrown == null) {
            return;
        }

        logByCauses(logLevel, thrown);
        logByClassAndLine(logLevel, thrown);
    }

    private void logByClassAndLine(String logLevel, Throwable thrown) {
        ListF<String> metricPath = Cf.arrayList(logLevel);
        for (StackTraceElement element : thrown.getStackTrace()) {
            if ("translate".equals(element.getMethodName())) {
                continue;
            } else if ("doTranslate".equals(element.getMethodName())) {
                continue;
            } else if (!element.getClassName().startsWith("ru.yandex")) {
                continue;
            } else if (element.getClassName().contains("Utils")) {
                continue;
            }

            metricPath.add(element.getClassName());
            metricPath.add(element.getMethodName());
            break;
        }

        if (metricPath.length() == 1) {
            metricPath.add("no_source");
        }

        exceptionsBySource.inc(new MetricName(metricPath), UpdateMode.RECURSIVE);
    }

    private void logByCauses(String logLevel, Throwable thrown) {
        ListF<String> metricPath = Cf.arrayList(logLevel);

        Throwable t = thrown;
        while (t != null) {
            metricPath.add(t.getClass().getSimpleName());
            t = t.getCause();
        }

        exceptions.inc(new MetricName(metricPath), UpdateMode.RECURSIVE);
    }

    @Override
    public MetricGroupName groupName(String instanceName) {
        return new MetricGroupName("log-errors",
                new MetricName("log", "errors"),
                "Log4J exceptions statistics");
    }
}
