package ru.yandex.chemodan.log;

import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Set;

import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.spi.StandardLevel;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

/**
 * Highly not efficient solution!
 *
 * TODO: migrate to native log4j2 solution (created cause we have dozen of Layouts)
 * @author vpronto
 */
@Deprecated
public class PatternLayoutBridge extends AbstractStringLayout {

    private final static Set<StandardLevel> STACK_TRACE_LEVELS = EnumSet.of(
            StandardLevel.FATAL,
            StandardLevel.WARN,
            StandardLevel.ERROR);

    private static final MapF<org.apache.logging.log4j.Level, Level> LEVELS = Cf.x(org.apache.logging.log4j.Level.values())
            .toMapMappingToValue(l -> org.apache.log4j.Level.toLevel(l.name()));

    private final PatternLayout patternLayout;
    PatternLayoutBridge(PatternLayout patternLayout) {
        super(Charset.forName("UTF-8"));
        this.patternLayout = patternLayout;
    }

    @Override
    public String toSerializable(LogEvent event) {
        return patternLayout.format(convert(event));
    }

    private static LoggingEvent convert(LogEvent event) {

        LocationInfo locationInfo = null;
        ThrowableInformation throwableInformation = null;
        // getting stacktrace is very expensive operation
        if (STACK_TRACE_LEVELS.contains(event.getLevel().getStandardLevel())) {
            StackTraceElement source = event.getSource();
            if (source != null) {
                locationInfo = new LocationInfo(source.getFileName(),
                        source.getClassName(),
                        source.getMethodName(),
                        String.valueOf(source.getLineNumber()));
            }
            if (event.getThrown() != null) {
                throwableInformation = new ThrowableInformation(event.getThrown());
            }
        }
        return new LoggingEvent(
                event.getLoggerFqcn(),
                event.getLoggerName(),
                event.getTimeMillis(),
                convertLevel(event.getLevel()),
                event.getMessage().getFormattedMessage(),
                event.getThreadName(),
                throwableInformation,
                null,
                locationInfo,
                event.getContextMap());
    }

    public static Level convertLevel(org.apache.logging.log4j.Level level) {
        return LEVELS.get(level);
    }
} //~
