package ru.yandex.chemodan.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;


/**
 * @author metal
 */
public class StdOutErrLogger {
    private static final Logger logger = LoggerFactory.getLogger(StdOutErrLogger.class);

    public static void redirectSystemOutErrToLog() {
        System.setOut(createLoggingProxy(Level.INFO));
        System.setErr(createLoggingProxy(Level.ERROR));

        logger.info("stdout and stderr were redirected to StdOutErrLogger");
    }

    public static PrintStream createLoggingProxy(Level logLevel) {
        return new PrintStream(new LoggerStream(logLevel), true);
    }

    private static class LoggerStream extends OutputStream {
        private final Level logLevel;
        private StringBuilder buffer = new StringBuilder();

        public LoggerStream(Level logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public void write(byte[] b) throws IOException {
            doWrite(new String(b));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            doWrite(new String(b, off, len));
        }

        @Override
        public void write(int b) throws IOException {
            doWrite(String.valueOf((char)b));
        }

        private void doWrite(String str) throws IOException {
            buffer.append(str);

            if (buffer.charAt(buffer.length() - 1) == '\n') {
                logger.log(logLevel, buffer.toString());
                buffer = new StringBuilder();
            }
        }
    }
}
