package ru.yandex.chemodan.log;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.layout.PatternLayout;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.log.utils.TskvEscapeUtils;
import ru.yandex.chemodan.log.utils.TskvPatternParser;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.log.log4j.YandexPatternLayout;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author metal
 * TODO: remove it and use PatternLayout.newBuilder().withPattern(pattern).build()
 * as a temp solution getPatternLayout() creates a new PatternLayout using old PATTERN_TEMPLATE
 */
@Deprecated
public class TskvLogPatternLayout extends YandexPatternLayout {
    private static final ListF<String> FIELDS_WITH_FORCED_EMPTY_VALUES = Cf.list("rid", "ycrid");

    private static final String PATTERN_TEMPLATE = ""
            + "tskv\ttskv_format=%s\t"
            + "logtime=%%d{yyyy-MM-dd HH:mm:ss,SSS}\tlogtimezone=%%d{XX}\tunixtime=%%D\t"
            + "host=%s%s\t"
            + "level=%%p\tthread=%%t%%X{ndc}%s\t%s%%m";

    private static final String NDC_KEY = "ndc";

    private boolean decomposeMessage;
    private boolean forceEmptyRidAndYcrid = false;

    protected TskvLogPatternLayout(String pattern) {
        super(pattern);
        this.decomposeMessage = true;
    }

    public TskvLogPatternLayout(String tskvFormat, boolean showClass, boolean decomposeMessage, String env) {
        super(resolveLayout(tskvFormat, showClass, decomposeMessage, env));
        this.decomposeMessage = decomposeMessage;
    }

    public TskvLogPatternLayout(String tskvFormat, boolean showClass, boolean decomposeMessage) {
        this(tskvFormat, showClass, decomposeMessage, logEnvironment());
    }

    public TskvLogPatternLayout(String tskvFormat, boolean decomposeMessage) {
        this(tskvFormat, true, decomposeMessage);
    }

    private static String resolveLayout(String tskvFormat, boolean showClass, boolean decomposeMessage) {
        return resolveLayout(tskvFormat, showClass, decomposeMessage, logEnvironment());
    }

    private static String resolveLayout(String tskvFormat, boolean showClass, boolean decomposeMessage, String env) {

        return resolveLayout(PATTERN_TEMPLATE, tskvFormat, showClass, decomposeMessage, env);
    }

    private static String resolveLayout(
            String template, String tskvFormat, boolean showClass, boolean decomposeMessage, String env)
    {

        return String.format(template,
                tskvFormat,
                HostnameUtils.localHostname(),
                env,
                showClass ? "\tclass=%c" : "",
                decomposeMessage ? "" : "message=");

    }

    public static String logEnvironment() {
        return EnvironmentType.PRODUCTION != EnvironmentType.getActive() ? "\tenv=" + EnvironmentType.getActive() : "";
    }

    public void setForceEmptyRidAndYcrid(boolean forceEmptyRidAndYcrid) {
        this.forceEmptyRidAndYcrid = forceEmptyRidAndYcrid;
    }

    public static Layout<? extends Serializable> getPatternLayout(
            String tskvFormat, boolean showClass, boolean decomposeMessage)
    {
        return getPatternLayout(tskvFormat, showClass, decomposeMessage, logEnvironment());
    }

    public static Layout<? extends Serializable> getPatternLayout(
            String tskvFormat, boolean showClass, boolean decomposeMessage, String env)
    {
        // Needs fixture. For workers'tasks %%rid! = %%X{ndc}
        String patchedTemplate = PATTERN_TEMPLATE
                .replace("unixtime=%%D", "unixtime=%%d{UNIX}")
                .replace("thread=%%t%%X{ndc}%s", "thread=%%t\trid=%%rid")
                + "%%n";
        String layout = resolveLayout(patchedTemplate, tskvFormat, showClass, decomposeMessage, env);
        return PatternLayout.newBuilder().withPattern(layout).build();
    }

    @Override
    public boolean ignoresThrowable() {
        return false;
    }

    @Override
    public String format(LoggingEvent event) {
        LoggingEvent modifiedEvent = new LoggingEvent(event.getFQNOfLoggerClass(),
                event.getLogger(), event.getTimeStamp(), event.getLevel(),
                escape(event.getRenderedMessage()),
                event.getThreadName(), event.getThrowableInformation(),
                null,
                event.getLocationInformation(),
                changeNdcCopyInMdcProperties(event.getProperties()));

        StringBuilder result = super.formatInternal(modifiedEvent);

        String[] stringRepresentation = event.getThrowableStrRep();
        if (stringRepresentation != null && stringRepresentation.length > 0) {
            result.append("\\n");
            for (String part : stringRepresentation) {
                result
                        .append(escape(part))
                        .append("\\n");
            }
        }
        result.append("\n");

        return result.toString();
    }

    @Override
    protected PatternParser createPatternParser(String s) {
        return new TskvPatternParser(s);
    }

    // TODO: fix it: generate 400mb of garbage per second under load
    @SuppressWarnings("unchecked")
    protected Map changeNdcCopyInMdcProperties(Map mdcProperties) {
        if (!mdcProperties.containsKey(NDC_KEY)) {
            return mdcProperties;
        }

        Map changedProperties = new HashMap(mdcProperties);
        changedProperties.put(NDC_KEY, changeNdc((String) changedProperties.get(NDC_KEY)));
        return changedProperties;
    }

    private String changeNdc(String rawNdc) {
        MapF<String, String> ndc = TskvNdcUtil.parseNdc(rawNdc);
        if (forceEmptyRidAndYcrid) {
            ndc = addEmptyValuesIfAbsent(Cf.toHashMap(ndc));
        }
        return formatNdc(ndc);
    }

    protected MapF<String, String> addEmptyValuesIfAbsent(MapF<String, String> ndc) {
        FIELDS_WITH_FORCED_EMPTY_VALUES.forEach(field -> ndc.putIfAbsent(field, "-"));
        return ndc;
    }

    protected String formatNdc(MapF<String, String> ndc) {
        StringBuilder result = new StringBuilder();
        for (Tuple2<String, String> tuple2 : ndc.entries()) {
            result
                    .append("\t")
                    .append(tuple2._1)
                    .append("=")
                    .append(tuple2._2);
        }
        return result.toString();
    }

    protected String escape(String string) {
        String[] symbolEscapes = decomposeMessage
                ? TskvEscapeUtils.DEFAULT_SYMBOL_ESCAPES_WITHOUT_TABULATION
                : TskvEscapeUtils.DEFAULT_SYMBOL_ESCAPES;
        return TskvEscapeUtils.escapeWithBackslash(string, symbolEscapes);
    }
}
