package ru.yandex.chemodan.log;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author dbrylev
 */
public class TskvLogger {
    public final String name;
    private final Logger logger;

    public TskvLogger(String name) {
        this.name = name;
        this.logger = LoggerFactory.getLogger(name);
    }

    public void log(Tuple2List<String, String> keyValues) {
        logger.info(keyValues.foldLeft("",
                (res, kv) -> res + (res.isEmpty() ? "" : "\t") + kv.get1() + "=" + kv.get2().replace('\t', ' ')));
    }
}
