package ru.yandex.chemodan.log;

import org.junit.Test;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TskvNdcUtilTest {
    @Test
    public void parseNdcMustParsePreservingOrder() {
        testParse(
                Tuple2List.fromPairs(
                        "key1", "value1",
                        "key2", "value2",
                        "key3", "value3"
                ),
                "#key1=value1,#key2=value2,#key3=value3"
        );
    }

    @Test
    public void parseNdcAppend() {
        testParse(
                Tuple2List.fromPairs(
                        "key1", "value1/value1_2",
                        "key2", "value2/value2_2",
                        "key3", "value3"
                ),
                "#key1=value1,#key2=value2,#key3=value3,#key2+=/value2_2,#key1+=/value1_2"
        );

    }

    private static void testParse(Tuple2List<String, String> expectedNdc, String ndcStr) {
        Assert.equals(
                expectedNdc,
                TskvNdcUtil.parseNdc(ndcStr)
                        .entries()
        );
    }
}
