package ru.yandex.chemodan.log.plugins;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternConverter;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.log.TskvNdcUtil;

/**
 * @author eoshch
 */
@Plugin(name = "RequestIdPatternConverter", category = PatternConverter.CATEGORY)
@ConverterKeys({"rid"})
public class RequestIdPatternConverter extends LogEventPatternConverter {
    private static final RequestIdPatternConverter instance = new RequestIdPatternConverter();

    private RequestIdPatternConverter() {
        super("rid", "rid");
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void format(final LogEvent event, final StringBuilder toAppendTo) {
        if (!event.getContextData().containsKey("ndc")) {
            toAppendTo.append("-");
            return;
        }
        String ndcRaw = event.getContextData().getValue("ndc");
        MapF<String, String> ndc = TskvNdcUtil.parseNdc(ndcRaw);
        toAppendTo.append(ndc.getOrElse("rid", "-"));
    }

    /**
     * Called by log4j.
     *
     * @param options the values that are specified within the curly braces that can follow the converter key.
     */
    public static RequestIdPatternConverter newInstance(final String[] options) {
        return instance;
    }
}
