package ru.yandex.chemodan.log.plugins;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternConverter;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringBuilders;

import ru.yandex.chemodan.log.utils.TskvEscapeUtils;

/**
 * @author eoshch
 */
@Plugin(name = "TskvEscapedMdcPatternConverter", category = PatternConverter.CATEGORY)
@ConverterKeys({"tskvX"})
public class TskvEscapedMdcPatternConverter extends LogEventPatternConverter {
    private final String key;

    private TskvEscapedMdcPatternConverter(String key) {
        super("tskvX{" + key + "}", "tskvx");
        this.key = key;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void format(final LogEvent event, final StringBuilder toAppendTo) {
        final ReadOnlyStringMap contextData = event.getContextData();
        String message = "-";
        if (contextData != null) {
            final Object value = contextData.getValue(key);
            if (value != null) {
                message = TskvEscapeUtils.escape(value.toString(),
                        TskvEscapeUtils.DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES);
            }
        }
        StringBuilders.appendValue(toAppendTo, message);
    }

    /**
     * Called by log4j.
     *
     * @param options the values that are specified within the curly braces that can follow the converter key.
     */
    public static TskvEscapedMdcPatternConverter newInstance(final String[] options) {
        if (options == null || options.length != 1) {
            throw new IllegalArgumentException();
        }
        return new TskvEscapedMdcPatternConverter(options[0]);
    }
}
