package ru.yandex.chemodan.log.plugins;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternConverter;

import ru.yandex.chemodan.log.utils.TskvEscapeUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author eoshch
 */
@Plugin(name = "TskvEscapedMessagePatternConverter", category = PatternConverter.CATEGORY)
@ConverterKeys({"tskvm"})
public class TskvEscapedMessagePatternConverter extends LogEventPatternConverter {
    private static final TskvEscapedMessagePatternConverter instance = new TskvEscapedMessagePatternConverter();

    private TskvEscapedMessagePatternConverter() {
        super("tskvm", "tskvm");
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void format(final LogEvent event, final StringBuilder toAppendTo) {
        String message = event.getMessage().getFormattedMessage();
        toAppendTo.append(StringUtils.isBlank(message) ? "-" :
                          TskvEscapeUtils.escape(message, TskvEscapeUtils.DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES));
    }

    /**
     * Called by log4j.
     *
     * @param options the values that are specified within the curly braces that can follow the converter key.
     */
    public static TskvEscapedMessagePatternConverter newInstance(final String[] options) {
        return instance;
    }
}
