package ru.yandex.chemodan.log.plugins;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternConverter;

import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.log.utils.TskvEscapeUtils;

/**
 * @author eoshch
 */
@Plugin(name = "TskvThrowablePatternConverter", category = PatternConverter.CATEGORY)
@ConverterKeys({"tskvex", "tskvexception", "tskvthrowable"})
public class TskvThrowablePatternConverter extends LogEventPatternConverter {
    // todo: implement full support of options of ThrowablePatternConverter
    private final Mode mode;

    private TskvThrowablePatternConverter(String[] options) {
        super("tskvthrowable", "tskvthrowable");
        if (options == null || options.length == 0) {
            this.mode = Mode.FULL;
        } else if (options.length == 1) {
            if (!Objects.equals(options[0], "short")) {
                throw new NotImplementedException(options[0]);
            }
            this.mode = Mode.SHORT;
        } else {
            throw new NotImplementedException("multiple options are not supported yet");
        }
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        final Throwable t = event.getThrown();
        if (t != null) {
            final int len = toAppendTo.length();
            if (len > 0 && !Character.isWhitespace(toAppendTo.charAt(len - 1))) {
                toAppendTo.append(' ');
            }

            if (mode == Mode.FULL) {
                final StringWriter w = new StringWriter();
                t.printStackTrace(new PrintWriter(w));
                toAppendTo.append(TskvEscapeUtils.escape(w.toString(),
                        TskvEscapeUtils.DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES));
            } else if (mode == Mode.SHORT) {
                toAppendTo.append(TskvEscapeUtils.escape(t.toString(),
                        TskvEscapeUtils.DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES));
            } else {
                throw new NotImplementedException();
            }
        }
    }

    @Override
    public boolean handlesThrowable() {
        return true;
    }

    /**
     * Called by log4j.
     *
     * @param options the values that are specified within the curly braces that can follow the converter key.
     */
    public static TskvThrowablePatternConverter newInstance(final String[] options) {
        return new TskvThrowablePatternConverter(options);
    }

    private enum Mode {
        FULL,
        SHORT,
    }
}
