package ru.yandex.chemodan.log.plugins;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternConverter;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.log.TskvNdcUtil;

/**
 * @author eoshch
 */
@Plugin(name = "YcridPatternConverter", category = PatternConverter.CATEGORY)
@ConverterKeys({"ycrid"})
public class YcridPatternConverter extends LogEventPatternConverter {
    private static final YcridPatternConverter instance = new YcridPatternConverter();

    private YcridPatternConverter() {
        super("ycrid", "ycrid");
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void format(final LogEvent event, final StringBuilder toAppendTo) {
        if (!event.getContextData().containsKey("ndc")) {
            toAppendTo.append("-");
            return;
        }
        String ndcRaw = event.getContextData().getValue("ndc");
        MapF<String, String> ndc = TskvNdcUtil.parseNdc(ndcRaw);
        toAppendTo.append(ndc.getOrElse("ycrid", "-"));
    }

    /**
     * Called by log4j.
     *
     * @param options the values that are specified within the curly braces that can follow the converter key.
     */
    public static YcridPatternConverter newInstance(final String[] options) {
        return instance;
    }
}


