package ru.yandex.chemodan.log.utils;

import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.log.mlf.Logger;

/**
 * @author dbrylev
 */
public interface CurryingLogger extends Logger {

    @Override
    default boolean isTraceEnabled() {
        return isEnabledFor(Level.TRACE);
    }

    @Override
    default void trace(Object message) {
        if (isTraceEnabled()) {
            log(Level.TRACE, message);
        }
    }

    @Override
    default void trace(String message) {
        if (isTraceEnabled()) {
            log(Level.TRACE, message);
        }
    }

    @Override
    default void trace(Throwable t) {
        if (isTraceEnabled()) {
            log(Level.TRACE, t);
        }
    }

    @Override
    default void trace(Object message, Throwable t) {
        if (isTraceEnabled()) {
            log(Level.TRACE, message, t);
        }
    }

    @Override
    default void trace(String message, Throwable t) {
        if (isTraceEnabled()) {
            log(Level.TRACE, message, t);
        }
    }

    @Override
    default void trace(String message, Object... args) {
        if (isTraceEnabled()) {
            log(Level.TRACE, message, args);
        }
    }

    @Override
    default boolean isDebugEnabled() {
        return isEnabledFor(Level.DEBUG);
    }

    @Override
    default void debug(Object message) {
        if (isDebugEnabled()) {
            log(Level.DEBUG, message);
        }
    }

    @Override
    default void debug(String message) {
        if (isDebugEnabled()) {
            log(Level.DEBUG, message);
        }
    }

    @Override
    default void debug(Throwable t) {
        if (isDebugEnabled()) {
            log(Level.DEBUG, t);
        }
    }

    @Override
    default void debug(Object message, Throwable t) {
        if (isDebugEnabled()) {
            log(Level.DEBUG, message, t);
        }
    }

    @Override
    default void debug(String message, Throwable t) {
        if (isDebugEnabled()) {
            log(Level.DEBUG, message, t);
        }
    }

    @Override
    default void debug(String message, Object... args) {
        if (isDebugEnabled()) {
            log(Level.DEBUG, message, args);
        }
    }

    @Override
    default boolean isInfoEnabled() {
        return isEnabledFor(Level.INFO);
    }

    @Override
    default void info(Object message) {
        if (isInfoEnabled()) {
            log(Level.INFO, message);
        }
    }

    @Override
    default void info(String message) {
        if (isInfoEnabled()) {
            log(Level.INFO, message);
        }
    }

    @Override
    default void info(Throwable t) {
        if (isInfoEnabled()) {
            log(Level.INFO, t);
        }
    }

    @Override
    default void info(Object message, Throwable t) {
        if (isInfoEnabled()) {
            log(Level.INFO, message, t);
        }
    }

    @Override
    default void info(String message, Throwable t) {
        if (isInfoEnabled()) {
            log(Level.INFO, message, t);
        }
    }

    @Override
    default void info(String message, Object... args) {
        if (isInfoEnabled()) {
            log(Level.INFO, message, args);
        }
    }

    @Override
    default void warn(Object message) {
        log(Level.WARN, message);
    }

    @Override
    default void warn(String message) {
        log(Level.WARN, message);
    }

    @Override
    default void warn(Throwable t) {
        log(Level.WARN, t);
    }

    @Override
    default void warn(Object message, Throwable t) {
        log(Level.WARN, message, t);
    }

    @Override
    default void warn(String message, Throwable t) {
        log(Level.WARN, message, t);
    }

    @Override
    default void warn(String message, Object... args) {
        log(Level.WARN, message, args);
    }

    @Override
    default void error(Object message) {
        log(Level.ERROR, message);
    }

    @Override
    default void error(String message) {
        log(Level.ERROR, message);
    }

    @Override
    default void error(Throwable t) {
        log(Level.ERROR, t);
    }

    @Override
    default void error(Object message, Throwable t) {
        log(Level.ERROR, message, t);
    }

    @Override
    default void error(String message, Throwable t) {
        log(Level.ERROR, message, t);
    }

    @Override
    default void error(String message, Object... args) {
        log(Level.ERROR, message, args);
    }
}
