package ru.yandex.chemodan.log.utils;

import javax.servlet.ServletRequest;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

/**
 * @author yashunsky
 * @author Dmitriy Amelin (lemeh)
 */
public class ExtraRequestLogFieldsUtil {
    private static final String EXTRA_FIELDS_ATTR = "extra-access-log-fields";

    public static MapF<String, String> getFields(ServletRequest req) {
        return getOrCreateCustomFields(req)
                .getFields();
    }

    public static void addField(ServletRequest req, String key, String value) {
        getOrCreateCustomFields(req)
                .put(key, value);
    }

    public static void addFields(ServletRequest req, MapF<String, String> fields) {
        getOrCreateCustomFields(req)
                .putAll(fields);
    }

    private static ExtraFields getOrCreateCustomFields(ServletRequest req) {
        Object attr = req.getAttribute(EXTRA_FIELDS_ATTR);
        if (attr != null) {
            if (!(attr instanceof ExtraFields)) {
                throw new IllegalStateException(EXTRA_FIELDS_ATTR + " attribute MUST be of type " + ExtraFields.class);
            }
            return (ExtraFields) attr;
        } else {
            ExtraFields fields = new ExtraFields();
            req.setAttribute(EXTRA_FIELDS_ATTR, fields);
            return fields;
        }
    }

    private static class ExtraFields {
        private final MapF<String, String> fields = Cf.linkedHashMap();

        public MapF<String, String> getFields() {
            return fields;
        }

        public void put(String key, String value) {
            this.fields.put(key, value);
        }

        public void putAll(MapF<String, String> fields) {
            this.fields.putAll(fields);
        }
    }
}
