package ru.yandex.chemodan.log.utils;

import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;

import ru.yandex.misc.log.LogRotation;
import ru.yandex.misc.log.LogRotationListener;

/**
 * listens hop event and rotate logs
 *
 * @author vpronto
 */
public class HupTriggeringPolicy implements TriggeringPolicy, LogRotationListener {

    public HupTriggeringPolicy() {
        LogRotation.addListener(this);
    }

    private final AtomicBoolean isRotate = new AtomicBoolean();

    @Override
    public void initialize(RollingFileManager manager) { }

    @Override
    public boolean isTriggeringEvent(LogEvent logEvent) {
        if (isRotate.get()) {
            return isRotate.compareAndSet(true, false);
        }
        return false;
    }

    @Override
    public void rotate() {
        isRotate.set(true);
    }
}
