package ru.yandex.chemodan.log.utils;

import java.io.File;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.log.LogRotation;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.test.TestDirRule;
import ru.yandex.misc.thread.ThreadUtils;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author vpronto
 */
public class HupTriggeringPolicyTest {

    @Rule
    public final TestDirRule testDir = new TestDirRule();

    @Before
    public void startAppender() {
        Log4jHelper.appenderBuilder().fileName(testDir.testDir + "/test.log").async(false).buffSize(0)
                .name(HupTriggeringPolicyTest.class.getName())
                .appName(new SimpleAppName("", "")).build();
        Log4jHelper.configureLogger(HupTriggeringPolicyTest.class, Level.INFO);
    }

    @Test
    public void test() throws InterruptedException {
        ru.yandex.misc.log.mlf.Logger logger = LoggerFactory.getLogger(HupTriggeringPolicyTest.class);
        logger.info("Test message 1");

        File testLog0 = new File(testDir.testDir.getFile(), "test.log");
        Assert.assertTrue(testLog0.exists());
        File testLog1 = new File(testDir.testDir.getFile(), "test.1.log");
        testLog0.renameTo(testLog1);

        logger.info("Test message 2");

        Assert.assertFalse(testLog0.exists());
        Assert.assertTrue(testLog1.exists());

        LogRotation.rotate();
        logger.info("Test message 3");
        logger.info("Test message 4");
        ThreadUtils.sleep(50);
        Assert.assertTrue("Log file doesn't exists: " + testLog0, testLog0.exists());
        Assert.assertTrue("Log file doesn't exists: " + testLog1, testLog1.exists());

        File testLog2 = new File(testDir.testDir.getFile(), "test.2.log");
        testLog0.renameTo(testLog2);

        // one more rotate for flushing
        LogRotation.rotate();
        logger.info("Test message 4");

        String content0 = new File2(testLog2).readText();
        String content1 = new File2(testLog1).readText();

        Assert.assertContains(content1, "Test message 1");
        Assert.assertContains(content1, "Test message 2");
        Assert.assertContains(content0, "Test message 3");
        Assert.assertContains(content0, "Test message 4");

    }

}

