package ru.yandex.chemodan.log.utils;

/**
 * @author metal
 * @author vpronto
 */
public class TskvEscapeUtils {

    public static final String[] DEFAULT_SYMBOL_ESCAPES_WITHOUT_TABULATION = new String[128];
    static {
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_TABULATION['\n'] = "\\n";
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_TABULATION['\r'] = "\\r";
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_TABULATION['\0'] = "\\0";
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_TABULATION['\"'] = "\\\"";
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_TABULATION['\\'] = "\\\\";
    }

    public static final String[] DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES = new String[128];
    static {
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES['\n'] = "\\n";
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES['\r'] = "\\r";
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES['\0'] = "\\0";
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES['\\'] = "\\\\";
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES['\t'] = "\\t";
    }

    public static final String[] DEFAULT_SYMBOL_ESCAPES = new String[128];
    static {
        DEFAULT_SYMBOL_ESCAPES['\n'] = "\\n";
        DEFAULT_SYMBOL_ESCAPES['\r'] = "\\r";
        DEFAULT_SYMBOL_ESCAPES['\0'] = "\\0";
        DEFAULT_SYMBOL_ESCAPES['\"'] = "\\\"";
        DEFAULT_SYMBOL_ESCAPES['\\'] = "\\\\";
        DEFAULT_SYMBOL_ESCAPES['\t'] = "\\t";
    }

    public static final String[] DEFAULT_SYMBOL_ESCAPES_ONLY_TABULATION = new String[128];
    static {
        DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES['\t'] = "\\t";
    }


    public static String escape(String string) {
        return escape(string, DEFAULT_SYMBOL_ESCAPES);
    }

    public static String escape(String line, String[] symbolEscapes) {

        StringBuilder sb = null;
        char lineChars[] = line.toCharArray();
        int k = 0;
        for (int i = 0; i < lineChars.length; i++) {
            char curr = lineChars[i];
            if (curr < symbolEscapes.length) {
                String str = symbolEscapes[curr];
                if (str != null) {
                    if (sb == null) {sb = new StringBuilder(lineChars.length + 16);}
                    sb.append(lineChars, k, i - k);
                    sb.append(str);
                    k = i + 1;
                }
            }
        }
        if (sb != null) {
            sb.append(lineChars, k, lineChars.length - k);
            return sb.toString();
        }

        return line;
    }

    public static String escapeWithBackslash(String string) {
        return escape(string);
    }

    public static String escapeWithBackslash(String string, String[] symbolEscapes) {
        return escape(string, symbolEscapes);
    }
}
