package ru.yandex.chemodan.log.utils;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

import static ru.yandex.chemodan.log.utils.TskvEscapeUtils.escape;
import static ru.yandex.chemodan.log.utils.TskvEscapeUtils.escapeWithBackslash;


/**
 * @author metal
 */
public class TskvEscapeUtilsTest {
    @Test
    public void escapeTest() {

        Assert.equals("\\\\n", escapeWithBackslash("\\n"));

        Assert.equals("aaa\\n\\r\\0\\t\\\"bbb", escape("aaa\n\r\0\t\"bbb"));
        Assert.equals("aaa\\n\\r\\0\\\"bbb\\\\ccc", escapeWithBackslash("aaa\n\r\0\"bbb\\ccc"));

        Assert.equals("aaa\\n\\r\\0\\\"bbb", escape("aaa\n\r\0\"bbb"));
        Assert.equals("aaa\\n\\r\\0\\\"bbb\\\\ccc", escapeWithBackslash("aaa\n\r\0\"bbb\\ccc"));
    }

}
