package ru.yandex.chemodan.log.utils;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

import ru.yandex.misc.regex.Matcher2;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author dbrylev
 */
public class YcridConverter extends PatternConverter {
    private static final Pattern2 pattern = Pattern2.compile("ycrid=([^\t|$]+)");

    public YcridConverter(FormattingInfo fi) {
        super(fi);
    }

    @Override
    protected String convert(LoggingEvent event) {
        String ndc = (String) event.getMDC("ndc");

        if (ndc == null) {
            return "-";
        }
        Matcher2 m = pattern.matcher2(ndc);
        return m.find() ? m.group(1).getOrElse("") : "";
    }
}
