package ru.yandex.chemodan.mds;

import ru.yandex.chemodan.boot.value.OverridableValue;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author vpronto
 */
public class MdsConfig extends DefaultObject {

    @OverridableValue("${mds.port.write:-1111}")
    private Integer writePort;

    @OverridableValue("${mds.port.read:-80}")
    private Integer readPort;

    @OverridableValue("${mds.host.write}")
    private String writeHost;

    @OverridableValue("${mds.host.read}")
    private String readHost;

    @OverridableValue("${mds.host.upload}")
    private String uploadHost;

    @OverridableValue("${mds.port.upload:-80}")
    private Integer uploadPort;

    @OverridableValue("${mds.browser.namespace}")
    private String namespace;

    @OverridableValue("${mds.browser.namespace.write.auth-header}")
    private String authHeader;

    public Integer getWritePort() {
        return writePort;
    }

    public void setWritePort(Integer writePort) {
        this.writePort = writePort;
    }

    public Integer getReadPort() {
        return readPort;
    }

    public void setReadPort(Integer readPort) {
        this.readPort = readPort;
    }

    public String getWriteHost() {
        return writeHost;
    }

    public void setWriteHost(String writeHost) {
        this.writeHost = writeHost;
    }

    public String getReadHost() {
        return readHost;
    }

    public void setReadHost(String readHost) {
        this.readHost = readHost;
    }

    public String getUploadHost() {
        return uploadHost;
    }

    public void setUploadHost(String uploadHost) {
        this.uploadHost = uploadHost;
    }

    public Integer getUploadPort() {
        return uploadPort;
    }

    public void setUploadPort(Integer uploadPort) {
        this.uploadPort = uploadPort;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getAuthHeader() {
        return authHeader;
    }

    public void setAuthHeader(String authHeader) {
        this.authHeader = authHeader;
    }
}
