package ru.yandex.chemodan.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.bson.BsonDocument;

import ru.yandex.commune.mongo3.MongoCollectionX;
import ru.yandex.commune.mongo3.schema.MongoCollectionIndexInfo;

/**
 * @author friendlyevil
 */
public abstract class AbstractMongoDao<TId, TEntity> implements MongoCollectionIndexInfo {
    protected final MongoDatabase database;
    protected final MongoCollectionX<TId, TEntity> collection;


    public AbstractMongoDao(MongoDatabase database, MongoCollectionX<TId, TEntity> collection) {
        this.database = database;
        this.collection = collection;
    }

    @Override
    public MongoCollection<BsonDocument> getCollection() {
        return collection.getCollection();
    }

    @Override
    public MongoDatabase getDatabase() {
        return database;
    }
}
