package ru.yandex.chemodan.monica;

import java.util.Arrays;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.monica.pusher.FieldValues;
import ru.yandex.misc.monica.core.blocks.StatisticData;
import ru.yandex.misc.monica.core.stat.quantile.QuantileValues;

/**
 * @author tolmalev
 */
public class BucketsFromStatisticsDataExtractor {

    private final DynamicProperty<ListF<Integer>> edgesList = new DynamicProperty<>(
            "solomon-extract-buckets-edges",
            Cf.list(1, 2, 5, 10, 25, 50, 100, 250, 500, 1000, 2000, 3000, 4000, 5000, 10000,
                    (int) Duration.standardMinutes(1).getMillis(),
                    (int)Duration.standardMinutes(2).getMillis(),
                    (int)Duration.standardMinutes(5).getMillis(),
                    (int)Duration.standardMinutes(10).getMillis(),
                    (int)Duration.standardMinutes(30).getMillis()
                    ));

    private final DynamicProperty<Boolean> removeEmpty = new DynamicProperty<>(
            "solomon-extract-buckets-edges-remove-empty", true);

    public FieldValues extract(StatisticData data) {
        try {
            int[] edges = edgesList.get().mapToIntArray(v -> v);

            double[] counts = new double[edges.length];

            double totalRps = data.getMeter().getAverage1Min();
            double prev = 0;
            for (QuantileValues.QuantileValue value : data.getQuantiles().asList()) {
                double cnt = totalRps * value.quantile - prev;
                prev = totalRps * value.quantile;

                int index = Arrays.binarySearch(edges, (int) Math.round(value.value));
                if (index < 0) {
                    index = -(index + 1);
                }

                if (index >= 0 && index < counts.length) {
                    counts[index] += cnt;
                }
            }

            Tuple2List<String, Double> values = Tuple2List.arrayList();
            for (int i = 0; i < edges.length; i++) {
                if (!removeEmpty.get() || counts[i] > 0.01) {
                    values.add(edges[i] + "ms", counts[i]);
                }
            }
            return new FieldValues(values);
        } catch (RuntimeException ignored) {
            return new FieldValues(Tuple2List.arrayList());
        }
    }
}
