package ru.yandex.chemodan.monica;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.Zk;
import ru.yandex.commune.zk2.primitives.ZkPathClient;
import ru.yandex.commune.zk2.primitives.group.GroupWatcherListener;
import ru.yandex.commune.zk2.primitives.group.ZkGroupWatcher;
import ru.yandex.misc.digest.Md5;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author tolmalev
 */
public class DiskGraphiteMetricsRegistry extends ZkPathClient implements GroupWatcherListener {

    private ListF<Pattern2> patterns = Cf.list();
    private ListF<String> patternsStrList = Cf.list();

    private final ZkGroupWatcher groupWatcher;

    public DiskGraphiteMetricsRegistry(ZkPath zkPath) {
        super(zkPath);
        this.groupWatcher = new ZkGroupWatcher(zkPath, this);
    }

    public ListF<Pattern2> getPatterns() {
        return patterns;
    }

    public ListF<String> getPatternStrings() {
        return patternsStrList;
    }

    public void addPattern(String patternStr) {
        patternStr = patternStr.trim();
        ZkPath child = patternNode(patternStr);
        zk().createOrUpdate(child, patternStr.getBytes());
    }

    public void removePattern(String patternStr) {
        patternStr = patternStr.trim();
        zk().deleteIfExists(patternNode(patternStr));
    }

    private ZkPath patternNode(String patternStr) {
        return path.child(Md5.A.digest(patternStr).hex());
    }

    @Override
    public void groupChanged(ListF<byte[]> members) {
        patterns = members.map(bytes -> Pattern2.compile(new String(bytes)));
        patternsStrList = members.map(String::new);
    }

    @Override
    public void initialize(Zk zk) {
        super.initialize(zk);
        groupWatcher.initialize(zk);
    }

    @Override
    public void expired() {
        super.expired();
        groupWatcher.expired();
    }
}
