package ru.yandex.chemodan.monica.intervaldistribution;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.function.Function;

/**
 * @author Dmitriy Amelin (lemeh)
 */
abstract class AbstractComparableIntervalGauge<T extends Comparable<T>> {
    private final ComparableIntervalBounds<T> bounds;

    public AbstractComparableIntervalGauge(CollectionF<T> bounds, Function<T, String> nameF) {
        this.bounds = new ComparableIntervalBounds<>(bounds, nameF);
    }

    protected void init() {
        this.bounds.keys().forEach(key -> inc(key, 0));
    }

    public void inc(T value) {
        inc(bounds.getKey(value), 1);
    }

    protected abstract void inc(String key, long delta);
}
