package ru.yandex.chemodan.monica.intervaldistribution;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;

/**
 * @author Dmitriy Amelin (lemeh)
 */
class ComparableIntervalBounds<T extends Comparable<T>> {
    private final ListF<T> sortedBounds;

    private final MapF<T, String> keyCache;

    public ComparableIntervalBounds(CollectionF<T> bounds, Function<T, String> nameF) {
        this.sortedBounds = bounds.unique().toList().sorted();
        this.keyCache = bounds.toMapMappingToValue(nameF);
    }

    public CollectionF<String> keys() {
        return keyCache.values();
    }

    public String getKey(T value) {
        return sortedBounds.find(bound -> value.compareTo(bound) <= 0)
                .map(keyCache::getTs)
                .getOrElse("other");
     }
}
