package ru.yandex.chemodan.monica.intervaldistribution;

import javax.annotation.concurrent.ThreadSafe;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function0;
import ru.yandex.misc.monica.core.Metered;
import ru.yandex.misc.monica.core.Metric;
import ru.yandex.misc.monica.core.Tickable;
import ru.yandex.misc.monica.core.blocks.Distribution;
import ru.yandex.misc.monica.core.blocks.DistributionData;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@ThreadSafe
public class ComparableIntervalDistribution<T extends Comparable<T>> extends AbstractComparableIntervalGauge<T>
        implements Function0<DistributionData>, Metric<DistributionData>, Tickable
{
    private final Distribution distribution = new Distribution();

    public ComparableIntervalDistribution(CollectionF<T> bounds, Function<T, String> nameF) {
        super(bounds, nameF);
        init();
    }

    @Override
    public Metered<DistributionData> meter() {
        return distribution.meter();
    }

    @Override
    public Class<DistributionData> measuredType() {
        return distribution.measuredType();
    }

    @Override
    public String getStatusText() {
        return distribution.getStatusText();
    }

    @Override
    public DistributionData apply() {
        return distribution.apply();
    }

    @Override
    public void tick(long nowMillis) {
        distribution.tick(nowMillis);
    }

    protected void inc(String key, long delta) {
        distribution.inc(key, delta);
    }
}
