package ru.yandex.chemodan.monica.intervaldistribution;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.bolts.function.Function2V;
import ru.yandex.misc.monica.core.Metric;
import ru.yandex.misc.monica.core.MetricMap;
import ru.yandex.misc.monica.core.blocks.AverageData;
import ru.yandex.misc.monica.core.blocks.DistributionData;
import ru.yandex.misc.monica.core.blocks.DistributionSource;
import ru.yandex.misc.monica.core.blocks.Meter;
import ru.yandex.misc.monica.core.blocks.MeterMapWithDistribution;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ComparableIntervalMetricMapWithDistribution<T extends Comparable<T>>
        extends AbstractComparableIntervalGauge<T> implements MetricMap<AverageData>, DistributionSource
{
    private final MeterMapWithDistribution meterMap = new MeterMapWithDistribution();

    public ComparableIntervalMetricMapWithDistribution(CollectionF<T> bounds, Function<T, String> nameF) {
        super(bounds, nameF);
        init();
    }

    public Meter get(MetricName name) {
        return meterMap.get(name);
    }

    @Override
    protected void inc(String key, long delta) {
        meterMap.inc(delta, key);
    }

    @Override
    public void setRegistrar(Function2V<MetricName, Metric<AverageData>> registrar) {
        meterMap.setRegistrar(registrar);
    }

    @Override
    public void setUnregistrar(Function1V<MetricName> unregistrar) {
        meterMap.setUnregistrar(unregistrar);
    }

    @Override
    public void clear() {
        meterMap.clear();
    }

    @Override
    public Class<AverageData> measuredType() {
        return meterMap.measuredType();
    }

    @Override
    public ListF<String> getDistributionNames() {
        return meterMap.getDistributionNames();
    }

    @Override
    public DistributionData getDistribution(String name) {
        return meterMap.getDistribution(name);
    }
}
