package ru.yandex.chemodan.monica.intervaldistribution;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.monica.core.Tickable;
import ru.yandex.misc.monica.core.blocks.DistributionData;

/**
 * @author Dmitry Amelin (lemeh)
 */
public class ComparableIntervalMetricMapWithDistributionTest extends
        AbstractComparableDistributionTest<ComparableIntervalMetricMapWithDistribution>
{
    @Override
    protected DistributionData extractDistributionData(ComparableIntervalMetricMapWithDistribution distribution) {
        distribution.setRegistrar((metricName, metric) -> ((Tickable) metric).tick(System.currentTimeMillis()));
        return distribution.getDistribution((String)distribution.getDistributionNames().first());
    }

    @Override
    protected <C extends Comparable<C>> ComparableIntervalMetricMapWithDistribution createGauge(ListF<C> bounds,
            Function<C, String> boundNameF)
    {
        return new ComparableIntervalMetricMapWithDistribution<>(bounds, boundNameF);
    }
}
