package ru.yandex.chemodan.monica.intervaldistribution;

import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TimeUtils {
    private static final PeriodFormatter PERIOD_FORMATTER = new PeriodFormatterBuilder()
            .appendDays()
            .appendSuffix("day", "days")
            .appendHours()
            .appendSuffix("hour", "hours")
            .appendMinutes()
            .appendSuffix("min")
            .appendSeconds()
            .appendSuffix("sec")
            .toFormatter();

    public static String formatSimple(Period period) {
        return PERIOD_FORMATTER.print(period);
    }

    private TimeUtils() {}
}
