package ru.yandex.chemodan.monica.intervaldistribution;

import org.joda.time.Duration;
import org.joda.time.Period;
import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TimeUtilsTest {
    @Test
    public void testSeconds() {
        Assert.equals("53sec", TimeUtils.formatSimple(Duration.standardSeconds(53).toPeriod()));
    }

    @Test
    public void testMinutes() {
        Assert.equals("21min", TimeUtils.formatSimple(Duration.standardMinutes(21).toPeriod()));
    }

    @Test
    public void testHours() {
        Duration duration = Duration.standardHours(1).plus(Duration.standardDays(8));
        Assert.equals("193hours", TimeUtils.formatSimple(duration.toPeriod()));
    }

    @Test
    public void testAll() {
        Period period = new Period(3, 5, 7, 0).plusDays(1);
        Assert.equals("1day3hours5min7sec", TimeUtils.formatSimple(period));
    }
}
