package ru.yandex.chemodan.mpfs;

import java.net.URI;
import java.util.Map;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;

/**
 * @author akirakozov
 */
public class MpfsCallbackResponse {
    private final int statusCode;
    private final String statusLine;
    private final String response;
    private final Map<String, String> headers;
    private final Option<URI> uri;

    public MpfsCallbackResponse(
            int statusCode, String statusLine, String response,
            Map<String, String> headers, Option<URI> uri)
    {
        this.statusCode = statusCode;
        this.statusLine = statusLine;
        this.response = response;
        this.headers = headers != null ? headers : Cf.map();
        this.uri = uri != null ? uri : Option.empty();
    }

    public int getStatusCode() {
        return statusCode;
    }

    public String getResponse() {
        return response;
    }

    public String getStatusLine() {
        return statusLine;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public Option<URI> getUri() {
        return uri;
    }

    @Override
    public String toString() {
        return "status_code = " + statusCode
                + ", status_line = " + statusLine
                + ", http_response = " + response
                + ", uri = " + (uri.isPresent() ? uri.get() : "");
    }

}
