package ru.yandex.chemodan.mpfs;

import java.io.IOException;
import java.net.URI;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.InputStreamSourceUtils;

/**
 * @author akirakozov
 */
public class MpfsCallbackResponseHandler implements ResponseHandler<MpfsCallbackResponse> {
    private final URI uri;

    public MpfsCallbackResponseHandler(URI uri) {
        this.uri = uri;
    }

    @Override
    public MpfsCallbackResponse handleResponse(HttpResponse response) throws IOException
    {
        int code = response.getStatusLine().getStatusCode();
        String statusLine = response.getStatusLine().toString();
        String responseText = InputStreamSourceUtils.wrap(response.getEntity().getContent()).readText();
        MapF<String, String> headers = Cf.hashMap();
        for (Header header : response.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }

        return new MpfsCallbackResponse(code, statusLine,
                responseText, headers.unmodifiable(), Option.of(uri));
    }

}
