package ru.yandex.chemodan.mpfs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

import lombok.Data;
import org.apache.http.HttpResponse;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.mpfs.lentablock.MpfsLentaBlockFullDescription;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.utils.Language;

public interface MpfsClient extends Closeable {
    boolean needInit(MpfsUser uid);

    void userInit(MpfsUser uid, Language locale, String source, Option<String> b2b);

    MpfsCallbackResponse markMulcaIdToRemove(MulcaId mulcaId);

    MpfsCallbackResponse getFullRelativeTree(MpfsUser uid, String path);

    MpfsCallbackResponse getFullRelativeTreePublic(String hash, boolean showNda);

    MpfsCallbackResponse getAlbumResources(String publicKey, Option<MpfsUser> uid);

    MpfsCallbackResponse getFilesResources(String mpfsOid, MpfsUser uid);

    MpfsFileInfo getFileInfoByHid(MpfsHid mpfsHid);


    /**
     * @deprecated use {@link #bulkInfoByResourceIds(MpfsUser, SetF, ListF, ListF)} to control proxying to djfs
     */
    @Deprecated
    default ListF<MpfsFileInfo> bulkInfoByResourceIds(
            MpfsUser uid, ListF<String> resourceIds, ListF<String> enableServiceIds)
    {
        return bulkInfoByResourceIds(uid, Cf.set(), resourceIds, enableServiceIds);
    }

    ListF<MpfsFileInfo> bulkInfoByResourceIds(MpfsUser uid, SetF<String> meta,
            ListF<String> resourceIds, ListF<String> enableServiceIds);

    /**
     * @deprecated use {@link #bulkInfoByResourceIds(MpfsUser, SetF, ListF)} to control proxying to djfs
     */
    @Deprecated
    default ListF<MpfsFileInfo> bulkInfoByResourceIds(MpfsUser uid, ListF<String> resourceIds) {
        return bulkInfoByResourceIds(uid, Cf.set(), resourceIds);
    }

    default ListF<MpfsFileInfo> bulkInfoByResourceIds(MpfsUser uid, SetF<String> meta, ListF<String> resourceIds) {
        return bulkInfoByResourceIds(uid, meta, resourceIds, Cf.list("/disk"));
    }

    /**
     * @deprecated use {@link #bulkInfoByPaths(MpfsUser, SetF, ListF)} to control proxying to djfs
     */
    @Deprecated
    default ListF<MpfsFileInfo> bulkInfoByPaths(MpfsUser uid, ListF<String> paths) {
        return bulkInfoByPaths(uid, Cf.set(), paths);
    }

    ListF<MpfsFileInfo> bulkInfoByPaths(MpfsUser uid, SetF<String> meta, ListF<String> paths);

    void streamingListByUidAndPath(MpfsUser uid, String path, Option<Integer> offset, Option<Integer> amount,
            Option<String> sort, boolean orderDesc,
            Function1V<Iterator<MpfsFileInfo>> callback);

    MpfsListResponse listByUidAndPath(MpfsUser uid, String path, Option<Integer> offset, Option<Integer> amount,
            Option<String> sort, boolean orderDesc);

    MpfsFileInfo getFileInfoByUidAndPath(MpfsUser uid, String path, MapF<String, Object> params, ListF<String> metaFields);

    MpfsFileInfo getFileInfoByUidAndPath(MpfsUser uid, String path, ListF<String> metaFields);

    void mkdir(MpfsUser uid, String path);

    String mksysdir(MpfsUser uid, String type);

    Option<MpfsShareFolderInvite> getNotApprovedInvite(MpfsUser uid, String hash);

    ListF<MpfsShareFolderInvite> getNotApprovedInvites(MpfsUser uid);

    Option<MpfsOperation> getOperation(MpfsUser uid, String oid);

    ListF<MpfsOperation> activeOperations(MpfsUser uid);

    MpfsStoreOperation astore(MpfsUser uid, String path, String md5, Tuple2List<String, String> headers);

    MpfsStoreOperation dstore(MpfsUser uid, String path, String md5, boolean iSwearIWillNeverPublishThisUrl);

    void setprop(MpfsUser uid, String path, MapF<String, String> properties);

    void uploadEmptyFile(MpfsUser uid, String path, MapF<String, Object> additionalParams);

    MpfsStoreOperation store(MpfsStoreOperationContext c, Tuple2List<String, String> headers);

    MpfsCallbackResponse setPrivate(MpfsUser uid, String path);

    MpfsCallbackResponse setPublic(MpfsUser uid, String path);

    MpfsCallbackResponse setPublic(MpfsUser uid, String path, Tuple2List<String, String> headers);

    String getPublicUrl(MpfsCallbackResponse response);

    MpfsPublicSettings getPublicSettings(MpfsUser uid, String path);

    MpfsPublicSettings getPublicSettingsByHash(MpfsUser uid, String hash);

    MpfsCallbackResponse stateRemove(MpfsUser uid, String key);

    MpfsCallbackResponse stateSet(MpfsUser uid, String key, String value);

    MpfsCallbackResponse settingRemove(MpfsUser uid, String namespace, String key);

    MpfsCallbackResponse settingSet(MpfsUser uid, String namespace, String key, String value);

    MpfsCallbackResponse setProp(MpfsUser uid, String path, Tuple2List<String, String> set, ListF<String> remove);

    void userInstallDevice(MpfsUser uid, String type, String deviceId, MapF<String, Object> params);

    <T> T diff(MpfsUser uid, String path, Option<Long> version,
            Function<HttpResponse, T> indexResponseProcessor);

    MpfsCallbackResponse rm(MpfsUser uid, String path);

    MpfsOperation asyncRm(MpfsUser uid, String path, Option<String> ifMatch, String callbackUrl);

    MpfsOperation asyncTrashAppend(MpfsUser uid, String path, Option<String> ifMatch, String callbackUrl);

    MpfsOperation asyncTrashDropAll(MpfsUser uid, String callbackUrl);

    MpfsCallbackResponse copy(MpfsUser uid, String srcPath, String dstPath, boolean checkHidsBlockings);

    MpfsOperation asyncCopy(MpfsUser uid, String srcPath, String dstPath, boolean overwrite, String callbackUrl);

    MpfsCallbackResponse move(MpfsUser uid, String srcPath, String dstPath, boolean checkHidsBlockings);

    MpfsOperation asyncMove(MpfsUser uid, String srcPath, String dstPath, boolean overwrite, String callbackUrl);

    Option<MpfsFileInfo> getFileInfoOByUidAndPath(MpfsUser uid, String path, ListF<String> metaFields);

    Option<MpfsFileInfo> getFileInfoOByFileId(MpfsUser owner, String fileId);

    Option<MpfsFileInfo> getFileInfoOByFileId(MpfsUser uid, String owner, String fileId);

    MpfsFileInfo getFileInfoByFileId(MpfsUser owner, String fileId);

    MpfsFileInfo getFileInfoByFileId(MpfsUser uid, String owner, String fileId);

    MpfsFileInfo getFileInfoByCommentId(MpfsUser uid, String entityType, String entityId);

    MpfsFileInfo getPublicInfo(String hash, Option<MpfsUser> uid);

    Option<MpfsFileInfo> getFileInfoOByPrivateHash(String privateHash);

    Option<MpfsCommentsPermissions> getCommentsPermissions(MpfsUser uid, String entityType, String entityId);

    Option<String> getSharedFolderPathByUidAndGroupId(MpfsUser uid, String groupId);

    String getPublicFileAddress(String privateHash);

    MpfsUserInfo getUserInfoObj(MpfsUser uid);

    ListF<MpfsUserServiceInfo> getUserServiceInfoList(MpfsUser uid);

    MapF<String, String> getDefaultFolders(MpfsUser uid);

    String getUserInfo(MpfsUser uid);

    Option<MapF<String, MapF<String, String>>> getUserSettingsO(MpfsUser uid);

    MpfsCallbackResponse getOfficeStoreInfo(String resourceId, String accessToken, String accessTokenTtl,
            MapF<String, String> headers);

    Option<MpfsGroupUids> getShareUidsInGroupO(MpfsUser owner, String fileId);

    MpfsGroupUids getShareUidsInGroup(MpfsUser uid, String owner, String fileId);

    Option<MpfsLentaBlockFileIds> getLentaBlocksFileIds(
            MpfsUser uid, String resourceId, String mediaType,
            MpfsUid modifier, int mtimeGte, int mtimeLte, int amount);

    Option<MpfsLentaBlockFullDescription> getLentaBlockFilesData(
            MpfsUser uid, String resourceId, String mediaType,
            MpfsUid modifier, int mtimeGte, int mtimeLte, int amount);

    Option<MpfsLentaBlockFullDescription> getLentaBlockFilesData(
            MpfsUser uid, String resourceId, String mediaType,
            MpfsUid modifier, int mtimeGte, int mtimeLte, int amount, String meta);

    String getMarkMulcaIdToRemoveUri(MulcaId mulcaId);

    String getFullRelativeTreeUri(String uid, String path);

    String getFullRelativeTreePublicUri(String hash, boolean showNda);

    String getAlbumResourcesListUri(String publicKey, Option<String> uid);

    String getFilesListUri(String mpfsOid, String uid);

    String getOfficeStoreUri(String resourceId, String accessToken, String accessTokenTtl);

    String getKladunDownloadCounterIncUri(String hash, long bytes);

    String getCommentsPermissionsUri(MpfsUser uid, String entityType, String entityId);

    String getShareFolderInfoUri(MpfsUser uid, String groupId);

    String getFileInfoUriByHid(MpfsHid hid);

    UriData getFileInfoUriByUidAndPath(String uid, String path, MapF<String, Object> params, ListF<String> metaFields);

    String getFileInfoUriByFileId(String uid, String owner, String fileId);

    String getFileInfoUriByCommentId(MpfsUser uid, String entityType, String entityId);

    String getResourceInfoUri(String privateHash);

    String getPublicFileAddressUri(String privateHash);

    String getUserInfoUri(String uid);

    String getServiceListUri(String uid);

    String getShareUidsInGroupUri(MpfsUser uid, String owner, String fileId);

    String getLentaBlocksFileIdsUri(
            MpfsUser uid, String resourceId, String mediaType,
            MpfsUid modifier, int mtimeGte, int mtimeLte, int amount);

    String getLentaBlockDataUri(
            MpfsUser uid, String resourceId, String mediaType,
            MpfsUid modifier, int mtimeGte, int mtimeLte, int amount, String metaFields);

    // For tests only
    void setMpfsHost(String mpfsHost);

    boolean isMpfsHost(String host);

    @Override
    void close() throws IOException;

    MpfsCallbackResponse shareInviteUser(MpfsUser uid, String realPath, int rightsInt, String login);

    void rejectInvite(MpfsUser uid, String hash);

    String acceptInvite(MpfsUser uid, String hash);

    int mobileSubscribe(MpfsUser uid, String token, Option<String> allow, String resources);

    int mobileUnsubscribe(MpfsUser uid, String token);

    String generateZaberunUrl(
            String stid,
            String fileName,
            String urlType,
            Option<String> uid,
            Option<String> md5,
            Option<String> contentType,
            Option<String> hash,
            Option<String> parser,
            Option<String> hid,
            Option<String> mediaType,
            Option<String> size,
            Option<Integer> limit,
            Option<Integer> fsize,
            Option<Integer> expireSeconds,
            Option<Integer> crop,
            Option<Boolean> inline,
            Option<Boolean> eternal);

    MpfsCallbackResponse initNotes(MpfsUser uid, String src, String dst, MapF<String, Object> metaParams);

    boolean isQuickMoveEnabled(String uid);

    Option<String> getFotkiAlbumItemUrl(PassportUid ownerUid, int albumId, String path);

    Option<String> getFotkiAlbumUrl(PassportUid ownerUid, int albumId);

    boolean arePhotosliceAlbumsEnabledSafe(MpfsUser uid);

    void processInappReceipt(PassportUid uid, String packageName,String storeType, String currency, String receipt);

    Map<String, Boolean> getFeatureToggles(MpfsUser uid);

    @Data
    class UriData {

        private final boolean djfs;

        private final String path;
    }
}
