package ru.yandex.chemodan.mpfs;

import lombok.Getter;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.util.bender.BenderJsonNodeUnmarshaller;
import ru.yandex.chemodan.util.json.JsonNodeUtils;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.Format;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.DurationAsMillisMarshaller;
import ru.yandex.misc.bender.custom.DurationAsMillisUnmarshaller;
import ru.yandex.misc.bender.custom.InstantAsMillisMarshaller;
import ru.yandex.misc.bender.custom.InstantAsMillisUnmarshaller;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.BenderJsonParser;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;
import ru.yandex.misc.bender.parse.MainUnmarshallerFactory;
import ru.yandex.misc.bender.serialize.MainMarshallerFactory;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Lev Tolmachev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
@Getter
public class MpfsFileInfo extends DefaultObject {
    private static final BenderConfiguration simpleBenderConfiguration =
            BenderConfiguration.cons(MembersToBind.WITH_ANNOTATIONS, false,
                    CustomMarshallerUnmarshallerFactoryBuilder.cons()
                            .add(Duration.class, new DurationAsMillisMarshaller(), new DurationAsMillisUnmarshaller())
                            .add(Instant.class, new InstantAsMillisMarshaller(), new InstantAsMillisUnmarshaller())
                            .add(BenderJsonNode.class, new BenderJsonNodeUnmarshaller())
                            .build());

    public static final CustomMarshallerUnmarshallerFactoryBuilder mpfsFileMetaMarshallerUnmarshallerFactoryBuilder = CustomMarshallerUnmarshallerFactoryBuilder.cons()
            .add(Duration.class, new DurationAsMillisMarshaller(), new DurationAsMillisUnmarshaller())
            .add(Instant.class, new InstantAsMillisMarshaller(), new InstantAsMillisUnmarshaller())
            .add(MpfsFileMeta.class,
                    new MainMarshallerFactory(Format.JSON, simpleBenderConfiguration)
                            .createMarshaller(ClassX.wrap(MpfsFileMetaDto.class).asType()),
                    new MainUnmarshallerFactory(Format.JSON, simpleBenderConfiguration)
                            .createUnmarshaller(ClassX.wrap(MpfsFileMetaDto.class).asType()))
            .add(BenderJsonNode.class, new BenderJsonNodeUnmarshaller());

    public static final BenderMapper mapper = new BenderMapper(
            BenderConfiguration.cons(MembersToBind.WITH_ANNOTATIONS, false,
                    mpfsFileMetaMarshallerUnmarshallerFactoryBuilder.build()));

    private static final BenderJsonParser<MpfsFileInfo> P = mapper.createParser(MpfsFileInfo.class);
    private static final BenderJsonParser<BenderJsonNode> LIST_P = mapper.createParser(BenderJsonNode.class);

    public final Option<String> name;
    public final Option<String> type;
    public final Option<String> path;
    private MpfsFileMeta meta;

    @BenderFlatten
    public final MpfsResourceTimes times;

    public MpfsFileInfo(String name, String type, MpfsFileMeta meta) {
        this(Option.of(name), Option.of(type), Option.empty(), meta, MpfsResourceTimes.ZERO);
    }

    public MpfsFileInfo(Option<String> name, Option<String> type, Option<String> path, MpfsFileMeta meta,
            MpfsResourceTimes times)
    {
        this.name = name;
        this.type = type;
        this.path = path;
        this.meta = meta;
        this.times = times;
    }

    public static MpfsFileInfo parse(BenderJsonNode node, SetF<String> requestedMeta) {
        MpfsFileInfo info = P.parseJson(node);
        ((MpfsFileMetaDto) info.meta).jsonNode = node.getField("meta").get();
        info.meta = RestrictMetaAccessInvocationHandler.wrap(info.meta, requestedMeta);
        return info;
    }

    public static MpfsFileInfo parse(BenderJsonNode node) {
        return parse(node, Cf.set());
    }

    public static MpfsFileInfo parse(String response) {
        return parse(new JacksonJsonNodeWrapper(JsonNodeUtils.getNode(response)), Cf.set());
    }

    public static ListF<MpfsFileInfo> parseList(String response) {
        return LIST_P.parseListJson(response).map(n -> parse(n, Cf.set()));
    }

    public static ListF<MpfsFileInfo> parseList(String response, SetF<String> requestedMeta) {
        return LIST_P.parseListJson(response).map(n -> parse(n, requestedMeta));
    }
}
