package ru.yandex.chemodan.mpfs;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.exception.PermanentHttpFailureException;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class MpfsFileInfoTest {

    @Test
    public void parser () {
        MpfsFileInfo info = MpfsFileInfo.parse("{\n"
                + "  \"ctime\": 1485340380,\n"
                + "  \"meta\": {\n"
                + "    \"digest_url\": \"https://downloader.dst.yandex.ru/disk/707fa1e8b43974d39c46ec0259042a9c5fb7c08908ce6ec0715b566f13459f08/589257e2/zUe9n33LscgMCJlP1YJIwqQqQv0fAVbY-1_YhSGMDds7pdrV7_Wm8zfzLG39KWKd4-VpqDiH5NXIjSENfLUk3Q%3D%3D?uid=3000077416&filename=test.txt&disposition=attachment&hash=&limit=0&content_type=application%2Foctet-stream&tknv=v2\",\n"
                + "    \"uid\": \"3000077416\",\n"
                + "    \"test|urn:yandexsdafsdfsd\": \"<><b>ha-ha-ha</b></>\",\n"
                + "    \"resource_id\": \"3000077416:aa5181d1baf70af9926c11c22bd6f06b87e2d0e53a5d0b0a310e691422891aa1\",\n"
                + "    \"short_url\": \"https://front.tst.clk.yandex.net/i/BeMYjJr0ZJqy\",\n"
                + "    \"labels\": [],\n"
                + "    \"visible\": 1,\n"
                + "    \"size\": 10,\n"
                + "    \"file_mid\": \"1000046.yadisk:3000077416.E720:297259517282884940958491235573\",\n"
                + "    \"source\": \"disk\",\n"
                + "    \"media_type\": \"document\",\n"
                + "    \"pmid\": \"1000044.yadisk:3000077416.E720:2972595172151747502963177846002\",\n"
                + "    \"sha256\": \"1715f801853bdbeea5b9f5e2c400db891a3c7bf63bfde04c353c6c63fc829843\",\n"
                + "    \"thumbnail\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=XXXS&crop=0\",\n"
                + "    \"revision\": 1485969573238672,\n"
                + "    \"drweb\": 1,\n"
                + "    \"wh_version\": \"1485969573238672\",\n"
                + "    \"mediatype\": \"document\",\n"
                + "    \"symlink\": \"3000077416:92013245822734928\",\n"
                + "    \"modify_uid\": \"3000077416\",\n"
                + "    \"public_hash\": \"UuPDxpIP7Rc2jWJLuOQ7eihHq/QVZc1cxg8Orwl+isQ=\",\n"
                + "    \"views_counter\": 0,\n"
                + "    \"hid\": \"81f2c4e344eb7447c63deb0fda89872b\",\n"
                + "    \"short_url_named\": \"https://front.tst.clk.yandex.net/i/BeMYjJr0ZJqy?test.txt\",\n"
                + "    \"digest_mid\": \"1000016.yadisk:3000077416.E1572:2972595172141221713160537531637\",\n"
                + "    \"md5\": \"bf61cd168a7df1023e561924d5993bf7\",\n"
                + "    \"mimetype\": \"text/plain\",\n"
                + "    \"albums_exclusions\": [\"beautiful\"],\n"
                + "    \"preview\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=S&crop=0\",\n"
                + "    \"custom_preview\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=S&crop=0\",\n"
                + "    \"sizes\": [\n"
                + "      {\n"
                + "        \"url\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2\",\n"
                + "        \"name\": \"DEFAULT\"\n"
                + "      },\n"
                + "      {\n"
                + "        \"url\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=XXXS&crop=0\",\n"
                + "        \"name\": \"XXXS\"\n"
                + "      },\n"
                + "      {\n"
                + "        \"url\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=XXS&crop=0\",\n"
                + "        \"name\": \"XXS\"\n"
                + "      },\n"
                + "      {\n"
                + "        \"url\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=XS&crop=0\",\n"
                + "        \"name\": \"XS\"\n"
                + "      },\n"
                + "      {\n"
                + "        \"url\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=S&crop=0\",\n"
                + "        \"name\": \"S\"\n"
                + "      },\n"
                + "      {\n"
                + "        \"url\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=M&crop=0\",\n"
                + "        \"name\": \"M\"\n"
                + "      },\n"
                + "      {\n"
                + "        \"url\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=L&crop=0\",\n"
                + "        \"name\": \"L\"\n"
                + "      },\n"
                + "      {\n"
                + "        \"url\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=XL&crop=0\",\n"
                + "        \"name\": \"XL\"\n"
                + "      },\n"
                + "      {\n"
                + "        \"url\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=XXL&crop=0\",\n"
                + "        \"name\": \"XXL\"\n"
                + "      },\n"
                + "      {\n"
                + "        \"url\": \"https://downloader.dst.yandex.ru/preview/88cdde44d04020e04fcb100fd5ed85a3027328124826c377c2585cdb3962bc03/inf/bpzEVHD5B5EdDBzbii_KCS1foox0l7-rnQfbIUyCaoJAyJfCGYoF2CUztKyicL4tvQqmzj1oi14BkO8jgcqdLg%3D%3D?uid=3000077416&filename=test.txt&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&size=XXXL&crop=0\",\n"
                + "        \"name\": \"XXXL\"\n"
                + "      }\n"
                + "    ],\n"
                + "    \"file_url\": \"https://downloader.dst.yandex.ru/disk/b1a96d91fca29c0e0afad095f472d39d04734caf3d8a623804d39d26111c96be/589257e2/WWTwC5KkImqXNj9QIN2BTC1foox0l7-rnQfbIUyCaoIBmPvujgTtvwWg0VFzJxs1W5xgsMEwyxSCIoo2qxFKlQ%3D%3D?uid=3000077416&filename=test.txt&disposition=attachment&hash=&limit=0&content_type=text%2Fplain&fsize=10&hid=81f2c4e344eb7447c63deb0fda89872b&media_type=document&tknv=v2&etag=bf61cd168a7df1023e561924d5993bf7\",\n"
                + "    \"public\": 1,\n"
                + "    \"comment_ids\": {\n"
                + "      \"public_resource\": \"3000077416:aa5181d1baf70af9926c11c22bd6f06b87e2d0e53a5d0b0a310e691422891aa1\"\n"
                + "    },\n"
                + "    \"file_id\": \"aa5181d1baf70af9926c11c22bd6f06b87e2d0e53a5d0b0a310e691422891aa1\"\n"
                + "  },\n"
                + "  \"mtime\": 1485969573,\n"
                + "  \"path\": \"/disk/test.txt\",\n"
                + "  \"utime\": 1485340380,\n"
                + "  \"type\": \"file\",\n"
                + "  \"id\": \"/disk/test.txt\",\n"
                + "  \"name\": \"test.txt\"\n"
                + "}\n");

        Assert.notNull(info.getMeta().getMetaJsonField("sizes"));
        Assert.notEmpty(info.getMeta().getAlbums_exclusions());
    }

    @Test
    public void check404() {
        Option<Boolean> ok404 = MpfsClientImpl.suppress404(() -> {
            throw new PermanentHttpFailureException("404", 404);
        });
        Assert.notNull(ok404);
    }

    @Test(expected = PermanentHttpFailureException.class)
    public void check401() {
        MpfsClientImpl.suppress404(() -> {
            throw new PermanentHttpFailureException("401", 401);
        });

    }

}
