package ru.yandex.chemodan.mpfs;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderJsonNode;

public interface MpfsFileMeta {
    Option<MpfsResourceId> getResourceId();

    Option<String> getSource();

    Option<String> getFileId();

    Option<String> getUid();

    Option<String> getPmid();

    Option<String> getFileMid();

    Option<ru.yandex.commune.video.format.FileInformation> getVideoInfo();

    Option<ru.yandex.misc.dataSize.DataSize> getSize();

    Option<Long> getPhotosliceTime();

    Option<Integer> getDrweb();

    Option<String> getPublicHash();

    Option<String> getShortUrl();

    Option<String> getShortNamed();

    Option<String> getSymlink();

    Option<String> getFileUrl();

    Option<String> getDigestUrl();

    Option<String> getDigestMid();

    Option<String> getFolderUrl();

    Option<String> getMd5();

    Option<String> getSha256();

    Option<String> getHid();

    Option<String> getMediaType();

    Option<String> getMimeType();

    Option<String> getPreview();

    Option<String> getCustomPreview();

    Option<Integer> getFotkiImageId();

    Option<Double> getAesthetics();

    Option<Integer> getWidth();

    Option<Integer> getHeight();

    Option<Integer> getVisible();

    Option<Integer> getHasfolders();

    Option<Integer> getNumfolders();

    Option<Integer> getNumfiles();

    Option<String> getFolderType();

    Option<String> getAlias_enabled();

    Option<String> getPhotoslice_album_type();

    ListF<String> getAlbums_exclusions();

    Option<Group> getGroup();

    Option<String> getFs_symbolic_link();

    Option<String> getEmpty();

    Option<String> getNoteAttachmentMtime();

    Option<BenderJsonNode> getMetaJsonField(String name);

    @BenderBindAllFields
    class Group {
        @BenderPart(name = "is_shared", strictName = true)
        public int is_shared;
        @BenderPart(name = "is_owned", strictName = true)
        public int is_owned;
        public Option<Integer> rights;
        public GroupOwner owner;
    }

    @BenderBindAllFields
    class GroupOwner {
        public Option<String> username;
//        remove due to problem CHEMODAN-37421
//        public String uid;
//        public String login;
    }
}
