package ru.yandex.chemodan.mpfs;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.video.format.FileInformation;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Lev Tolmachev
 */
@BenderBindAllFields
@Getter
@AllArgsConstructor
public class MpfsFileMetaDto extends DefaultObject implements MpfsFileMeta {
    @BenderPart(name = "resource_id", strictName = true)
    private final Option<MpfsResourceId> resourceId;

    private final Option<String> source;

    @BenderPart(name = "file_id", strictName = true)
    private final Option<String> fileId;

    @BenderPart(name = "uid", strictName = true)
    private final Option<String> uid;

    private final Option<String> pmid;
    @BenderPart(name = "file_mid", strictName = true)
    private final Option<String> fileMid;
    @BenderPart(name = "video_info", strictName = true)
    private final Option<FileInformation> videoInfo;
    @BenderPart(name = "size", strictName = true)
    private final Option<DataSize> size;
    @BenderPart(name = "empty", strictName = true)
    private final Option<String> empty;

    @BenderPart(name = "photoslice_time", strictName = true)
    private final Option<Long> photosliceTime;
    @BenderPart(name = "drweb", strictName = true)
    private final Option<Integer> drweb;

    @BenderPart(name = "public_hash", strictName = true)
    private final Option<String> publicHash;
    @BenderPart(name = "short_url", strictName = true)
    private final Option<String> shortUrl;
    @BenderPart(name = "short_url_named", strictName = true)
    private final Option<String> shortNamed;
    @BenderPart(name = "symlink", strictName = true)
    private final Option<String> symlink;
    @BenderPart(name = "file_url", strictName = true)
    private final Option<String> fileUrl;
    @BenderPart(name = "digest_url", strictName = true)
    private final Option<String> digestUrl;
    @BenderPart(name = "digest_mid", strictName = true)
    private final Option<String> digestMid;
    @BenderPart(name = "folder_url", strictName = true)
    private final Option<String> folderUrl;

    @BenderPart(name = "md5", strictName = true)
    private final Option<String> md5;
    @BenderPart(name = "sha256", strictName = true)
    private final Option<String> sha256;
    @BenderPart(name = "hid", strictName = true)
    private final Option<String> hid;
    @BenderPart(name = "mediatype", strictName = true)
    private final Option<String> mediaType;
    @BenderPart(name = "mimetype", strictName = true)
    private final Option<String> mimeType;

    @BenderPart(name = "preview", strictName = true)
    private final Option<String> preview;
    @BenderPart(name = "custom_preview", strictName = true)
    private final Option<String> customPreview;

    @BenderPart(name = "fotki_image_id", strictName = true)
    private final Option<Integer> fotkiImageId;

    @BenderPart(name = "aesthetics", strictName = true)
    private final Option<Double> aesthetics;
    @BenderPart(name = "width", strictName = true)
    private final Option<Integer> width;
    @BenderPart(name = "height", strictName = true)
    private final Option<Integer> height;

    private final Option<Integer> visible;

    private final Option<Integer> hasfolders;
    private final Option<Integer> numfolders;
    private final Option<Integer> numfiles;

    @BenderPart(name = "folder_type", strictName = true)
    private final Option<String> folderType;
    @BenderPart(name = "alias_enabled", strictName = true)
    private final Option<String> alias_enabled;
    @BenderPart(name = "photoslice_album_type", strictName = true)
    private final Option<String> photoslice_album_type;
    @BenderPart(name = "albums_exclusions", strictName = true)
    private final ListF<String> albums_exclusions;

    private final Option<Group> group;

    @BenderPart(name = "fs_symbolic_link", strictName = true)
    private final Option<String> fs_symbolic_link;

    @BenderPart(name = "note_attachment_mtime", strictName = true)
    private final Option<String> noteAttachmentMtime;

    @BenderIgnore
    BenderJsonNode jsonNode;

    @Builder
    public MpfsFileMetaDto(
            MpfsResourceId resourceId,
            String source,
            String fileId,
            String uid,
            String pmid,
            String fileMid,
            FileInformation videoInfo,
            DataSize size,
            Long photosliceTime,
            Integer drweb,
            String publicHash,
            String shortUrl,
            String shortNamed,
            String symlink,
            String fileUrl,
            String digestUrl,
            String digestMid,
            String folderUrl,
            String md5,
            String sha256,
            String hid,
            String mediaType,
            String mimeType,
            String preview,
            String customPreview,
            Integer fotkiImageId,
            Integer visible,
            Integer hasfolders,
            Integer numfolders,
            Integer numfiles,
            String folderType,
            String alias_enabled,
            String photoslice_album_type,
            List<String> albums_exclusions,
            Double aesthetics,
            Integer width,
            Integer height,
            Group group,
            String fsSymbolicLink,
            String empty,
            String noteAttachmentMtime)
    {
        this.resourceId = Option.ofNullable(resourceId);
        this.source = Option.ofNullable(source);
        this.fileId = Option.ofNullable(fileId);
        this.uid = Option.ofNullable(uid);
        this.pmid = Option.ofNullable(pmid);
        this.fileMid = Option.ofNullable(fileMid);
        this.videoInfo = Option.ofNullable(videoInfo);
        this.size = Option.ofNullable(size);
        this.photosliceTime = Option.ofNullable(photosliceTime);
        this.drweb = Option.ofNullable(drweb);
        this.publicHash = Option.ofNullable(publicHash);
        this.shortUrl = Option.ofNullable(shortUrl);
        this.shortNamed = Option.ofNullable(shortNamed);
        this.symlink = Option.ofNullable(symlink);
        this.fileUrl = Option.ofNullable(fileUrl);
        this.digestUrl = Option.ofNullable(digestUrl);
        this.digestMid = Option.ofNullable(digestMid);
        this.folderUrl = Option.ofNullable(folderUrl);
        this.md5 = Option.ofNullable(md5);
        this.sha256 = Option.ofNullable(sha256);
        this.hid = Option.ofNullable(hid);
        this.mediaType = Option.ofNullable(mediaType);
        this.mimeType = Option.ofNullable(mimeType);
        this.preview = Option.ofNullable(preview);
        this.customPreview = Option.ofNullable(customPreview);
        this.fotkiImageId = Option.ofNullable(fotkiImageId);
        this.visible = Option.ofNullable(visible);
        this.hasfolders = Option.ofNullable(hasfolders);
        this.numfolders = Option.ofNullable(numfolders);
        this.numfiles = Option.ofNullable(numfiles);
        this.folderType = Option.ofNullable(folderType);
        this.alias_enabled = Option.ofNullable(alias_enabled);
        this.photoslice_album_type = Option.ofNullable(photoslice_album_type);
        this.albums_exclusions = albums_exclusions == null ? Cf.list() : Cf.x(albums_exclusions);
        this.aesthetics = Option.ofNullable(aesthetics);
        this.width = Option.ofNullable(width);
        this.height = Option.ofNullable(height);
        this.group = Option.ofNullable(group);
        this.fs_symbolic_link = Option.ofNullable(fsSymbolicLink);
        this.empty = Option.ofNullable(empty);
        this.noteAttachmentMtime = Option.ofNullable(noteAttachmentMtime);
    }

    @Override
    public Option<BenderJsonNode> getMetaJsonField(String name) {
        return jsonNode.getField(name);
    }

}
