package ru.yandex.chemodan.mpfs;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.config.BenderConfiguration;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class MpfsGroupUids {

    public static final BenderParserSerializer<MpfsGroupUids> PS =
            Bender.cons(MpfsGroupUids.class, BenderConfiguration.defaultConfiguration());

    public final ListF<User> users;

    public MpfsGroupUids(ListF<User> users) {
        this.users = users;
    }

    public ListF<PassportUid> getUids() {
        return users.map(u -> u.uid);
    }

    public enum Status {
        OWNER,
        APPROVED,
    }

    @BenderBindAllFields
    @AllArgsConstructor
    public static class User {
        public final PassportUid uid;
        public final Status status;
    }
}
