package ru.yandex.chemodan.mpfs;

import java.io.IOException;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.io.IoUtils;

/**
 * @author ssytnik
 */
public class MpfsManager {

    private static final ObjectMapper objectMapper = new ObjectMapper();

    public ListF<MpfsResourceInfo> parseFullTreeOutput(String fullTreeJsonOutput) {
        ListF<MpfsResourceInfo> res = Cf.arrayList();
        JsonNode o = null;
        try {
            o = objectMapper.readTree(fullTreeJsonOutput);
        } catch (IOException e) {
            IoUtils.translate(e);
        }

        doParseFullTreeNode(res, o);

        return res;
    }

    private void doParseFullTreeNode(ListF<MpfsResourceInfo> appendableList, JsonNode o) {
        appendableList.add(MpfsResourceInfo.cons(o.get("this")));

        for (JsonNode v : o.get("list")) {
            doParseFullTreeNode(appendableList, v);
        }
    }

}
