package ru.yandex.chemodan.mpfs;

import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.io.cl.ClassLoaderUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author ssytnik
 */
public class MpfsManagerTest {

    @Test
    public void parseFullTreeJsonOutput() {
        String json =
                "{" +
                "\"this\":{\"ctime\":1363178682,\"meta\":{},\"mtime\":1363178682,\"path\":\"/\",\"type\":\"dir\",\"id\":\"5181427:/\",\"name\":\"Several\"}," +
                "\"list\":[" +
                    "{\"this\":{\"ctime\":1363178726,\"meta\":{\"file_mid\":\"1000005.yadisk:5181427.39832963845030709632093076944\"},\"mtime\":1363178733,\"path\":\"/cut1.jpg\",\"type\":\"file\",\"id\":\"5181427:/cut1.jpg\",\"name\":\"cut1.jpg\"},\"list\":[]}," +
                    "{\"this\":{\"ctime\":1363178739,\"meta\":{\"file_mid\":\"1000001.yadisk:5181427.3983296384147549947661425941959\"},\"mtime\":1363178742,\"path\":\"/ddddddddddd.jpg\",\"type\":\"file\",\"id\":\"5181427:/ddddddddddd.jpg\",\"name\":\"ddddddddddd.jpg\"},\"list\":[]}" +
                "]}";
        ListF<MpfsResourceInfo> list = new MpfsManager().parseFullTreeOutput(json);

        Assert.hasSize(3, list);
        Assert.equals(new MpfsResourceInfo(
                new Instant(1363178726000L), new Instant(1363178733000L), "/cut1.jpg", "file",
                "5181427:/cut1.jpg", "cut1.jpg",
                Cf.<String, Object>map("file_mid", "1000005.yadisk:5181427.39832963845030709632093076944")),
                list.get(1));

        Assert.isTrue(list.get(0).isFolder());
        Assert.isTrue(list.get(0).getNormalizedPath().endsWith("/"));
        Assert.isFalse(list.get(1).isFolder());
        Assert.isFalse(list.get(1).getNormalizedPath().endsWith("/"));
    }

    @Test
    public void parseAlbumResourceListing() {
        String result = ClassLoaderUtils.loadText(this.getClass(), "album_resources_list.json");
        ListF<MpfsResourceInfo> list = new MpfsManager().parseFullTreeOutput(result);

        Assert.hasSize(6, list);
    }
}
