package ru.yandex.chemodan.mpfs;

import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.bender.BenderJsonNodeUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
@Getter
public class MpfsOperation extends DefaultObject {

    protected static final BenderMapper mapper = new BenderMapper(
            new BenderConfiguration(BenderConfiguration.defaultSettings(), CustomMarshallerUnmarshallerFactoryBuilder
                    .cons()
                    .add(BenderJsonNode.class, new BenderJsonNodeUnmarshaller())
            .build()));

    public static final BenderParser<MpfsOperation> P = mapper.createParser(MpfsOperation.class);

    private Option<String> oid;
    private Option<String> id;
    private Option<String> type;
    private Option<String> subtype;
    private Option<String> status;

    private Option<Long> ctime;
    private Option<Long> mtime;

    private Option<BenderJsonNode> data;

    public String getOid() {
        return oid.orElse(id).get();
    }

}
