package ru.yandex.chemodan.mpfs;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.SneakyThrows;
import org.codehaus.jparsec.internal.util.Lists;
import org.joda.time.Instant;

import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author friendlyevil
 */
@NoArgsConstructor
@AllArgsConstructor
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class MpfsPublicSettings extends DefaultObject implements JacksonPojo {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @JsonProperty("read_only")
    private boolean readOnly = false;
    @JsonProperty("have_password")
    private boolean havePassword = false;
    @JsonProperty("available_until")
    private Instant availableUntil;
    @JsonProperty("external_organization_ids")
    private List<Integer> externalOrganizationIds = Lists.arrayList();

    @SneakyThrows
    public static MpfsPublicSettings parse(String response) {
        return objectMapper.readValue(response, MpfsPublicSettings.class);
    }

    @SneakyThrows
    public byte[] serialize() {
        return objectMapper.writeValueAsBytes(this);
    }
}
