package ru.yandex.chemodan.mpfs;

import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;

/**
 * @author friendlyevil
 */
public class MpfsPublicSettingsTest {

    @Test
    public void testParseFullFields() {
        String response = "{\"read_only\": true, \"have_password\": true, \"external_organization_ids\": [1234, 4321], \"available_until\": 1655461584}";

        MpfsPublicSettings settings = MpfsPublicSettings.parse(response);
        Assert.assertTrue(settings.isReadOnly());
        Assert.assertTrue(settings.isHavePassword());
        Assert.assertEquals(settings.getExternalOrganizationIds(), Cf.list(1234, 4321));
        Assert.assertEquals(settings.getAvailableUntil(), new Instant(1655461584));
    }

    @Test
    public void testParseZeroFields() {
        String response = "{}";

        MpfsPublicSettings settings = MpfsPublicSettings.parse(response);
        Assert.assertFalse(settings.isReadOnly());
        Assert.assertFalse(settings.isHavePassword());
        Assert.assertEquals(settings.getExternalOrganizationIds(), Cf.list());
        Assert.assertNull(settings.getAvailableUntil());
    }

    @Test
    public void testParsePartFields() {
        String response = "{\"read_only\": true, \"external_organization_ids\": [1234]}";

        MpfsPublicSettings settings = MpfsPublicSettings.parse(response);
        Assert.assertTrue(settings.isReadOnly());
        Assert.assertFalse(settings.isHavePassword());
        Assert.assertEquals(settings.getExternalOrganizationIds(), Cf.list(1234));
        Assert.assertNull(settings.getAvailableUntil());
    }
}
