package ru.yandex.chemodan.mpfs;

import ru.yandex.misc.ToStringSerializable;
import ru.yandex.misc.bender.annotation.BenderTextValue;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class MpfsResourceId extends DefaultObject implements ToStringSerializable {

    public final MpfsUid owner;

    public final String fileId;

    public MpfsResourceId(MpfsUid owner, String fileId) {
        this.owner = owner;
        this.fileId = fileId;
    }

    public static MpfsResourceId parse(String id) {
        int dotIdx = id.indexOf(':');
        return new MpfsResourceId(new MpfsUid(id.substring(0, dotIdx)), id.substring(dotIdx + 1));
    }

    @BenderTextValue
    public static MpfsResourceId benderParse(String id) {
        return id.equals("None") ? null : parse(id);
    }

    @BenderTextValue
    public String serialize() {
        return owner + ":" + fileId;
    }

    @Override
    public String toString() {
        return serialize();
    }
}
