package ru.yandex.chemodan.mpfs;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@Bendable
@BenderBindAllFields
@Getter
@AllArgsConstructor
public class MpfsResourceTimes extends DefaultObject {
    public static final MpfsResourceTimes ZERO = new MpfsResourceTimes(0, Option.empty(), 0, 0);

    @BenderDefaultValue("0")
    public final long ctime;
    public final Option<Long> etime;
    @BenderDefaultValue("0")
    public final long mtime;
    @BenderDefaultValue("0")
    public final long utime;

}
