package ru.yandex.chemodan.mpfs;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author friendlyevil
 */
public class MpfsResponseParserUtilsTest {
    private static final String TITLE = "API unavailable. Files exceed available storage space. Delete unnecessary " +
            "files or increase your Yandex.Disk storage space.";

    @Test
    public void test5xxStatus() {
        String body = generateBody();
        Option<String> title = MpfsResponseParserUtils.getTitleFromMpfsResponse(502, Option.of(body), Cf.set());
        checkFullTitle(title);
    }

    @Test
    public void testCodeInWhiteList() {
        int code = 123;
        String body = generateBody(code);
        Option<String> title = MpfsResponseParserUtils.getTitleFromMpfsResponse(403, Option.of(body), Cf.set(code));
        checkFullTitle(title);
        title = MpfsResponseParserUtils.getTitleFromMpfsResponse(Option.of(body), Cf.set(code));
        checkFullTitle(title);
    }

    @Test
    public void testCodeNotInWhiteList() {
        int code = 123;
        String body = generateBody(code);
        Option<String> title = MpfsResponseParserUtils.getTitleFromMpfsResponse(403, Option.of(body), Cf.set(321));
        checkEmptyTitle(title);
    }

    @Test
    public void testAnswerWithoutTitle() {
        String body = "{\"code\":123}";
        Option<String> title = MpfsResponseParserUtils.getTitleFromMpfsResponse(Option.of(body), Cf.set(123));
        checkEmptyTitle(title);
    }

    @Test
    public void testAnswerWithoutBody() {
        Option<String> title = MpfsResponseParserUtils.getTitleFromMpfsResponse(Option.empty(), Cf.set(123));
        checkEmptyTitle(title);
    }

    @Test
    public void testIncorrectJsonInBody() {
        String body = "\"code\":123";
        Option<String> title = MpfsResponseParserUtils.getTitleFromMpfsResponse(Option.of(body), Cf.set(123));
        checkEmptyTitle(title);
    }

    @Test
    public void testJsonInTitle() {
        String originalTitle = "{\\\"reason\\\":\\\"<reason>\\\",\\\"value\\\":12345}";
        String body = generateBody(321, originalTitle);
        Option<String> title = MpfsResponseParserUtils.getTitleFromMpfsResponse(Option.of(body), Cf.set(321));
        Assert.some("{\"reason\":\"<reason>\",\"value\":12345}", title);
    }

    private void checkEmptyTitle(Option<String> title) {
        Assert.isTrue(title.isEmpty());
    }

    private void checkFullTitle(Option<String> title) {
        Assert.some(TITLE, title);
    }

    private static String generateBody() {
        return generateBody(123);
    }

    private static String generateBody(int code) {
        return generateBody(code, TITLE);
    }

    private static String generateBody(int code, String title) {
        return "{\"code\":" + code + ",\"title\":\"" + title + "\"}";
    }


}
