package ru.yandex.chemodan.mpfs;

import lombok.Builder;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;

/**
 * @author vpronto
 */
@Builder
public class MpfsStoreOperationContext {

    final MpfsUser uid;
    final String path;
    final boolean force;
    @Builder.Default final Option<String> callback = Option.empty();
    @Builder.Default final Option<String> md5 = Option.empty();
    @Builder.Default final Option<String> sha256 = Option.empty();
    @Builder.Default final Option<Long> size = Option.empty();

    @Builder.Default final Option<String> livePhotoMd5 = Option.empty();
    @Builder.Default final Option<String> livePhotoSha256 = Option.empty();
    @Builder.Default final Option<String> livePhotoType = Option.empty();
    @Builder.Default final Option<Long> livePhotoSize = Option.empty();
    @Builder.Default final Option<String> livePhotoOperation = Option.empty();

    @Builder.Default final Option<String> photostreamDestination = Option.empty();

    @Builder.Default final Option<String> deviceResourceSubtype = Option.empty();
    @Builder.Default final Option<String> deviceCollections = Option.empty();
    @Builder.Default final Option<String> deviceOriginalPath = Option.empty();

    @Builder.Default final Option<String> sourceId = Option.empty();
    @Builder.Default final Option<String> forceDeletionLogDeduplication = Option.empty();

    @Builder.Default final Option<String> replaceMd5 = Option.empty();
    @Builder.Default final Option<Instant> ctime = Option.empty();
    @Builder.Default final Option<Instant> mtime = Option.empty();
    @Builder.Default final Option<Instant> etime = Option.empty();
    final boolean isHidden;
    final boolean isScreenshot;
    final boolean isPublic;
    final boolean iSwearIWillNeverPublishThisUrl;

    final MapF<String, Object> additionalParams;

    public static class MpfsStoreOperationContextBuilder {
        private MapF<String, Object> additionalParams = Cf.hashMap();

        public MpfsStoreOperationContextBuilder addParam(String key, Object value) {
            this.additionalParams.put(key, value);
            return this;
        }
    }

}
