package ru.yandex.chemodan.mpfs;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderTextValue;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class MpfsUid extends DefaultObject {
    public static final MpfsUid EMPTY = new MpfsUid("");

    public final Either<PassportUid, String> value;

    private MpfsUid(Either<PassportUid, String> value) {
        this.value = value;
    }

    public MpfsUid(PassportUid uid) {
        this(Either.left(uid));
    }

    public MpfsUid(Long uid) {
        this(new PassportUid(uid));
    }

    public MpfsUid(String specialUid) {
        this(parseEitherPassportOrString(specialUid));
    }

    private static Either<PassportUid, String> parseEitherPassportOrString(String specialUid) {
        if (StringUtils.isNumericArabic(specialUid)) {
            return Either.left(new PassportUid(Long.parseLong(specialUid)));
        } else {
            return Either.right(specialUid);
        }
    }

    public boolean isSpecial() {
        return value.isRight();
    }

    public String getSpecialUid() {
        return value.getRight();
    }

    public PassportUid getUid() {
        return value.getLeft();
    }

    public Option<PassportUid> getUidO() {
        return value.leftO();
    }

    @Override
    public String toString() {
        return getRawValue();
    }

    @BenderTextValue
    public static MpfsUid parse(String rawValue) {
        return new MpfsUid(parseEitherPassportOrString(rawValue));
    }

    @BenderTextValue
    public String getRawValue() {
        return isSpecial() ? getSpecialUid() : getUid().toString();
    }
}
