package ru.yandex.chemodan.mpfs;

import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author dbrylev
 */
public interface MpfsUser {

    String getUidStr();

    static MpfsUser of(String uid) {
        return new Simple(uid);
    }

    static MpfsUser of(long uid) {
        return new Simple(Long.toString(uid));
    }

    static MpfsUser of(PassportUid uid) {
        return new Simple(uid.toString());
    }

    static MpfsUser of(PassportUidOrZero uid) {
        return new Simple(uid.toString());
    }

    static MpfsUser of(MpfsUid uid) {
        return new Simple(uid.getRawValue());
    }

    @AllArgsConstructor
    @EqualsAndHashCode
    @Getter
    class Simple implements MpfsUser {
        private final String uidStr;
    }
}
