package ru.yandex.chemodan.mpfs;

import lombok.Getter;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderJsonParser;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 * TODO: add constructor and make it immutable
 */
@BenderBindAllFields
@Getter
public class MpfsUserInfo extends DefaultObject {
    public static final BenderJsonParser<MpfsUserInfo> P = Bender.jsonParser(MpfsUserInfo.class);

    public Space space;
    @BenderPart(name = "unlimited_autoupload_enabled", strictName = true)
    public Option<Integer> unlimitedAutouploadEnabled = Option.empty();
    public Settings settings;
    public MapF<String, MapF<String, String>> states;

    @BenderBindAllFields
    @Getter
    public static class Space extends DefaultObject {
        public Option<Long> free;
        public Option<Long> used;
        public Option<Long> limit;
        @BenderPart(name = "filesize_limit", strictName = true)
        public Option<Long> filesize_limit;
        @BenderPart(name = "paid_filesize_limit", strictName = true)
        public Option<Long> paid_filesize_limit;
        public Option<Long> trash;
    }

    @BenderBindAllFields
    public static class Settings extends DefaultObject {
        public MapF<String, String> photostream;
    }

    @BenderPart(name = "photoslice_albums_enabled", strictName = true)
    public Option<Integer> photosliceAlbumsEnabled = Option.empty();
}
