package ru.yandex.chemodan.mpfs;

import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class MpfsUserServiceInfoTest {

    @Test
    public void parse() {
        String json = "[\n" +
                "    {\n" +
                "        \"ctime\": 1421305130,\n" +
                "        \"expires\": null,\n" +
                "        \"free\": true,\n" +
                "        \"name\": \"blat_250\",\n" +
                "        \"names\": {\n" +
                "            \"en\": \"For friends of Yandex\",\n" +
                "            \"ru\": \"\\u0414\\u0440\\u0443\\u0437\\u044c\\u044f\\u043c \\u042f\\u043d\\u0434\\u0435\\u043a\\u0441\\u0430\",\n" +
                "            \"tr\": \"Yandex dostlar\\u0131 i\\u00e7in\",\n" +
                "            \"uk\": \"\\u0414\\u0440\\u0443\\u0437\\u044f\\u043c \\u042f\\u043d\\u0434\\u0435\\u043a\\u0441\\u0430\"\n" +
                "        },\n" +
                "        \"order\": null,\n" +
                "        \"removes\": null,\n" +
                "        \"sid\": \"144a0a895153abaddda38db5d2e59ad1\",\n" +
                "        \"size\": 268435456000,\n" +
                "        \"state\": null,\n" +
                "        \"subscription\": false\n" +
                "    },\n" +
                "    {\n" +
                "        \"ctime\": 1384545841,\n" +
                "        \"expires\": null,\n" +
                "        \"free\": true,\n" +
                "        \"name\": \"referral\",\n" +
                "        \"names\": {\n" +
                "            \"en\": \"Invite your friends\",\n" +
                "            \"ru\": \"\\u041f\\u0440\\u0438\\u0433\\u043b\\u0430\\u0448\\u0435\\u043d\\u0438\\u044f \\u0434\\u043b\\u044f \\u0434\\u0440\\u0443\\u0437\\u0435\\u0439\",\n" +
                "            \"tr\": \"Arkada\\u015f davetleri\",\n" +
                "            \"uk\": \"\\u0417\\u0430\\u043f\\u0440\\u043e\\u0448\\u0435\\u043d\\u043d\\u044f \\u0434\\u043b\\u044f \\u0434\\u0440\\u0443\\u0437\\u0456\\u0432\"\n" +
                "        },\n" +
                "        \"order\": null,\n" +
                "        \"removes\": null,\n" +
                "        \"sid\": \"2abc5ecce02cd0886789cbcbbb531386\",\n" +
                "        \"size\": 536870912,\n" +
                "        \"state\": null,\n" +
                "        \"subscription\": false\n" +
                "    }" +
                "]";

        ListF<MpfsUserServiceInfo> infos = MpfsUserServiceInfo.P.parseListJson(json);
        Assert.hasSize(2, infos);
        Assert.equals("blat_250", infos.get(0).name);
        Assert.equals("referral", infos.get(1).name);
    }
}
